#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

int max_value(int N, const vector<int>& A, const vector<int>& B) {
    vector<int> prefix_xor(N + 1, 0);
    vector<int> prefix_and(N + 1, 0xFFFFFFFF);
    for (int i = 1; i <= N; ++i) {
        prefix_xor[i] = prefix_xor[i - 1] ^ A[i - 1];
        prefix_and[i] = prefix_and[i - 1] & B[i - 1];
    }
    int max_result = 0;
    for (int L = 0; L < N; ++L) {
        for (int R = L; R < N; ++R) {
            int xor_value = prefix_xor[R + 1] ^ prefix_xor[L];
            int and_value = prefix_and[R + 1] & prefix_and[L];
            max_result = max(max_result, xor_value * and_value);
        }
    }

    return max_result;
}

int main() {
    int N;
    cin >> N;
    vector<int> A(N), B(N);
    for (int i = 0; i < N; ++i) {
        cin >> A[i];
    }
    for (int i = 0; i < N; ++i) {
        cin >> B[i];
    }
    cout << max_value(N, A, B) << endl;

    return 0;
}